<?php

namespace AcademyBA\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Registration extends \Bricks\Element {

	public $category     = 'academy';
	public $name         = 'academy-registration';
	public $icon         = 'ti-user';

	/**
	 * Widget Label
	 */
	public function get_label() {
		return esc_html__( 'Student/Instructor Registration', 'academy-bricks-addons' );
	}

	/**
	 * Controls Group
	 */
	public function set_control_groups() {
		$this->control_groups['registration_type_group'] = [
			'title' => esc_html__( 'Registration Type', 'academy-bricks-addons' ),
			'tab'	=> 'content',	
		];

		$this->control_groups['registration_form_style_group'] = [
			'title' => esc_html__( 'Registration form Style', 'academy-bricks-addons' ),
			'tab'	=> 'style',	
		];
		
		$this->control_groups['registration_form_typography_group'] = [
			'title' => esc_html__( 'Registration form Typography Style', 'academy-bricks-addons' ),
			'tab'	=> 'style',	
		];

		$this->control_groups['after_registration_group'] = [
			'title' => esc_html__( 'After Registration Style', 'academy-bricks-addons' ),
			'tab'	=> 'style',	
		];
	}
	/**
	 * Controls
	 */
	public function set_controls() {
		

		// ===== CONTENT TAB =====
		$this->controls['registration_type'] = [
			'group'   => 'registration_type_group',
			'type'    => 'select',
			'label'   => esc_html__( 'Registration Type', 'academy-bricks-addons' ),
			'options' => [
				'student'    => esc_html__( 'Student', 'academy-bricks-addons' ),
				'instructor' => esc_html__( 'Instructor', 'academy-bricks-addons' ),
			],
			'default' => 'student',
		];

		// ===== STYLE TAB =====

		// Form Tabs
		$this->controls['registration_form_tabs_style'] = [
			'group'	=> 'registration_form_style_group',
			'label' => esc_html__( 'Background', 'academy-bricks-addons' ),
			'type'  => 'color',
			'css'	=>[
				[
					'property'	=> 'background-color',
					'selector'	=> '.academy-reg-form',
				]
			]
		];

		$this->controls['registration_form_box_shadow'] = [
			'group' => 'registration_form_style_group',
			'label' => esc_html__( 'Box Shadow', 'academy-bricks-addons' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property'	=> 'box-shadow',
					'selector' => '.academy-reg-form',
				],
			],
		];

		$this->controls['registration_button_normal_style'] = [
			'group' => 'registration_form_style_group',
			'label' => esc_html__( 'Button Color', 'academy-bricks-addons' ),
			'type'  => 'color',
			'css'   => [
				[
					'property'  => 'background-color',
					'selector'  => '.academy-btn',
					'important' => true
				],
			],
		];

		$this->controls['registration_button_hv_style'] = [
		    'group'   => 'registration_form_style_group',
		    'label'   => esc_html__('Button Hover Color', 'academy-bricks-addons'),
		    'type'    => 'color',
		    'css'     => [
		        [
					'property'  => 'background-color',
					'selector'  => '.academy-btn:hover',
					'important' => true
		        ],
		    ],
		];


		/**
		 * Typography
		 */

		$this->controls['form_label'] = [
			'group' => 'registration_form_typography_group',
			'label' => esc_html__( 'Label Typography', 'academy-bricks-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'typography',
					'selector' => '.academy-form-group label',
				],
			],
		];

		$this->controls['form_placeholder_style'] = [
			'group' => 'registration_form_typography_group',
			'label' => esc_html__( 'Placeholder Typography', 'academy-bricks-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'typography',
					'selector' => '.academy-form-group input::placeholder',
				],
			],
		];

		$this->controls['form_field_style'] = [
			'group' => 'registration_form_typography_group',
			'label' => esc_html__( 'Field Typography', 'academy-bricks-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'typography',
					'selector' => '.academy-form-group input',
				],
			],
		];

		$this->controls['registration_button_typography'] = [
			'group' => 'registration_form_typography_group',
			'label' => esc_html__( 'Button Typography', 'academy-bricks-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'typography',
					'selector' => '.academy-btn--bg-purple',
				],
			],
			'exclude' => [
				'text-align'
			]
		];

		/**
		 * After Registration
		 */
		$this->controls['thankyou_typography_style'] = [
			'group'	=> 'after_registration_group',
			'label' => esc_html__( 'Heading Typography', 'academy-bricks-addons' ),
			'type'	=> 'typography',
			'css'	=> [
				[
					'property' => 'typography',
					'selector'	=> '.academy-reg-thankyou .academy-reg-thankyou__heading',
				]
			]
		];

		$this->controls['pending_typography_style'] = [
			'group'	=> 'after_registration_group',
			'label' => esc_html__( 'Pending Typography', 'academy-bricks-addons' ),
			'type'	=> 'typography',
			'css'	=> [
				[
					'property' => 'typography',
					'selector'	=> '.academy-reg-thankyou .academy-reg-thankyou__error',
				]
			]
		];

		$this->controls['description_typography_style'] = [
			'group'	=> 'after_registration_group',
			'label' => esc_html__( 'Description Typography', 'academy-bricks-addons' ),
			'type'	=> 'typography',
			'css'	=> [
				[
					'property' => 'typography',
					'selector'	=> '.academy-reg-thankyou .academy-reg-thankyou__description',
				]
			]
		];

		// Dashboard Button Typography
		$this->controls['dashboard_button_typography'] = [
			'group'   => 'after_registration_group',
			'label'   => esc_html__('Button Typography', 'academy-bricks-addons'),
			'type'    => 'typography',
			'css'     => [
				[
					'property' => 'typography',
					'selector' => '.academy-reg-thankyou .academy-btn',
				]
			]
		];

		// Dashboard Button Background (Normal)
		$this->controls['dashboard_button_bg'] = [
			'group'   => 'after_registration_group',
			'label'   => esc_html__('Button Background', 'academy-bricks-addons'),
			'type'    => 'color',
			'css'     => [
				[
					'property' => 'background-color',
					'selector' => '.academy-reg-thankyou .academy-btn',
				],
			],
		];

		// Dashboard Button Background (Hover)
		$this->controls['dashboard_button_bg_hover'] = [
			'group'   => 'after_registration_group',
			'label'   => esc_html__('Button Hover Background', 'academy-bricks-addons'),
			'type'    => 'color',
			'css'     => [
				[
					'property' => 'background-color',
					'selector' => '.academy-reg-thankyou .academy-btn:hover',
				],
			],
		];

		// Dashboard Button Text Color
		$this->controls['dashboard_button_color'] = [
			'group'   => 'after_registration_group',
			'label'   => esc_html__('Button Text Color', 'academy-bricks-addons'),
			'type'    => 'color',
			'css'     => [
				[
					'property' => 'color',
					'selector' => '.academy-reg-thankyou .academy-btn',
				],
			],
		];

		// Dashboard Button Text Color (Hover)
		$this->controls['dashboard_button_color_hover'] = [
			'group'   => 'after_registration_group',
			'label'   => esc_html__('Button Hover Text Color', 'academy-bricks-addons'),
			'type'    => 'color',
			'css'     => [
				[
					'property' => 'color',
					'selector' => '.academy-reg-thankyou .academy-btn:hover',
				],
			],
		];
	}

	public function render() {

		$settings = $this->settings ?? [];

		if (( function_exists('bricks_is_builder') && bricks_is_builder() ) ) {
			return false;
		}else{
			add_filter( 'academy/shortcode/instructor_registration_form_is_user_logged_in', '__return_false' );
			add_filter( 'academy/shortcode/student_registration_form_is_user_logged_in', '__return_false' );
		}

		$attr_array = [
			'role'  => $settings['registration_type'] ?? 'student',
		];

		$shortcode = ($settings['registration_type'] ?? 'student') === 'instructor'
			? '[academy_instructor_registration_form ' . $this->build_shortcode_atts($attr_array) . ']'
			: '[academy_student_registration_form ' . $this->build_shortcode_atts($attr_array) . ']';

		echo '<div class="academyea-widget-registration"'. $this->render_attributes('_root') .'>';
		echo do_shortcode($shortcode);
		echo '</div>';
	}

	/**
	 * Build Shortcode Attributes
	 */
	private function build_shortcode_atts($atts) {
		$out = [];
		foreach ($atts as $key => $val) {
			if (!empty($val)) {
				if (is_array($val)) {
					$val = implode(',', $val); 
				}
				$out[] = $key . '="' . esc_attr($val) . '"';
			}
		}
		return implode(' ', $out);
	}

}