<?php

namespace AcademyBA\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class LoginForm extends \Bricks\Element {

	public $category = 'academy';
	public $name     = 'academy-login-form';
	public $icon     = 'ti-lock';

	public function get_label() {
		return esc_html__( 'Login Form', 'academy-bricks-addons' );
	}

	public function set_control_groups() {
		$this->control_groups['content_control_group'] = [
			'title' => esc_html__( 'Content Controls Group', 'academy-bricks-addons' ),
			'tab'	=> 'content',
			
		];
		
		$this->control_groups['login_form_style_group'] = [
			'title' => esc_html__( 'Login Form', 'academy-bricks-addons' ),
			'tab'   => 'style',
		];
		
		$this->control_groups['login_form_typography_group'] = [
			'title' => esc_html__( 'Typography', 'academy-bricks-addons' ),
			'tab'   => 'style',
		];
	}

	public function set_controls() {
		// --- Content Controls ---
		$this->controls['form_title'] = [
			'group' => 'content_control_group',
			'label' => esc_html__( 'Form Title', 'academy-bricks-addons' ),
			'type'  => 'text',
			'placeholder' => esc_html__( 'Log In into your Account', 'academy-bricks-addons' ),
			'default' => 'Log In into your Account',
		];

		$this->controls['username_label'] = [
			'group' => 'content_control_group',
			'label' => esc_html__( 'Username Label', 'academy-bricks-addons' ),
			'type'  => 'text',
			'default' => esc_html__( 'Username or Email Address', 'academy-bricks-addons' ),
		];

		$this->controls['username_placeholder'] = [
			'group' => 'content_control_group',
			'label' => esc_html__( 'Username Placeholder', 'academy-bricks-addons' ),
			'type'  => 'text',
			'default' => esc_html__( 'Username or Email Address', 'academy-bricks-addons' ),
		];

		$this->controls['password_label'] = [
			'group' => 'content_control_group',
			'label' => esc_html__( 'Password Label', 'academy-bricks-addons' ),
			'type'  => 'text',
			'default' => esc_html__( 'Password', 'academy-bricks-addons' ),
		];

		$this->controls['password_placeholder'] = [
			'group' => 'content_control_group',
			'label' => esc_html__( 'Password Placeholder', 'academy-bricks-addons' ),
			'type'  => 'text',
			'default' => esc_html__( 'Password', 'academy-bricks-addons' ),
		];

		$this->controls['remember_label'] = [
			'group' => 'content_control_group',
			'label' => esc_html__( 'Remember Me Label', 'academy-bricks-addons' ),
			'type'  => 'text',
			'default' => esc_html__( 'Remember Me', 'academy-bricks-addons' ),
		];

		$this->controls['reset_password_label'] = [
			'group' => 'content_control_group',
			'label' => esc_html__( 'Reset Password Label', 'academy-bricks-addons' ),
			'type'  => 'text',
			'default' => esc_html__( 'Reset Password', 'academy-bricks-addons' ),
		];

		$this->controls['login_button_label'] = [
			'group' => 'content_control_group',
			'label' => esc_html__( 'Login Button Text', 'academy-bricks-addons' ),
			'type'  => 'text',
			'default' => esc_html__( 'Log In', 'academy-bricks-addons' ),
		];

		/**
		 * Style
		 */

		$this->controls['login_form_normal_style'] = [
			'group' => 'login_form_style_group',
			'label' => esc_html__( 'Background Color', 'academy-bricks-addons' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.academy-login-form-wrapper',
				],
			],
		];

		$this->controls['login_form_border'] = [
			'group' => 'login_form_style_group',
			'label' => esc_html__( 'Border', 'academy-bricks-addons' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => '.academy-login-form-wrapper',
				],
			],
		];

		$this->controls['login_form_box_shadow'] = [
			'group' => 'login_form_style_group',
			'label' => esc_html__( 'Box Shadow', 'academy-bricks-addons' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property'	=> 'box-shadow',
					'selector' => '.academy-login-form-wrapper',
				],
			],
		];

		// button normal color
		$this->controls['login_button_normal_style'] = [
			'group' => 'login_form_style_group',
			'label' => esc_html__( 'Button Color', 'academy-bricks-addons' ),
			'type'  => 'color',
			'css'   => [
				[
					'property'  => 'background-color',
					'selector'  => '.academy-btn',
					'important' => true
				]
			],
		];

		// button hover color
		$this->controls['login_button_hv_style'] = [
			'group' => 'login_form_style_group',
			'label' => esc_html__( 'Button hover color', 'academy-bricks-addons' ),
			'type'  => 'color',
			'css'   => [
				[
					'property'  => 'background-color',
					'selector'  => '.academy-btn:hover',
					'important' => true
				]
			],
		];
		
		// button hover text color
		$this->controls['login_button_text_hv_style'] = [
			'group' => 'login_form_style_group',
			'label' => esc_html__( 'Button hover text color', 'academy-bricks-addons' ),
			'type'  => 'color',
			'css'   => [
				[
					'property'  => 'color',
					'selector'  => '.academy-btn:hover',
					'important' => true
				]
			],
		];

		/**
		 * Typography
		 */
		$this->controls['form_heading_style'] = [
			'group' => 'login_form_typography_group',
			'label' => esc_html__( 'Heading Typography', 'academy-bricks-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'typography',
					'selector' => '.academy-login-form-wrapper .academy-login-form-heading',
				],
			],
		];

		$this->controls['form_label'] = [
			'group' => 'login_form_typography_group',
			'label' => esc_html__( 'Label Typography', 'academy-bricks-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'typography',
					'selector' => '.academy-form-group label',
				],
			],
		];

		$this->controls['form_placeholder_style'] = [
			'group' => 'login_form_typography_group',
			'label' => esc_html__( 'Placeholder Typography', 'academy-bricks-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'typography',
					'selector' => '.academy-form-group input::placeholder',
				],
			],
		];

		$this->controls['form_field_style'] = [
			'group' => 'login_form_typography_group',
			'label' => esc_html__( 'Field Typography', 'academy-bricks-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'typography',
					'selector' => '.academy-form-group input',
				],
			],
		];

		$this->controls['login_button_typography'] = [
			'group' => 'login_form_typography_group',
			'label' => esc_html__( 'Button Typography', 'academy-bricks-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'typography',
					'selector' => '.academy-btn',
				],
			],
			'exclude' => [
				'text-align'
			]
		];
	}

	public function render() {
		$settings = $this->settings ?? [];

		if (( function_exists('bricks_is_builder') && bricks_is_builder() ) ) {
			return false;
		}else{
			add_filter( 'academy/shortcode/login_form_is_user_logged_in', '__return_false' );
		}

		$attr_array = [
			'form_title' => $settings['form_title'] ?? '',
			'username_label' => $settings['username_label'] ?? '',
			'username_placeholder' => $settings['username_placeholder'] ?? '',
			'password_label' => $settings['password_label'] ?? '',
			'password_placeholder' => $settings['password_placeholder'] ?? '',
			'remember_label' => $settings['remember_label'] ?? '',
			'login_button_label' => $settings['login_button_label'] ?? '',
			'reset_password_label' => $settings['reset_password_label'] ?? '',
		];

		$shortcode = '[academy_login_form ' . $this->build_shortcode_atts($attr_array) . ']';

		echo '<div ' . $this->render_attributes('_root') . '>';
		echo do_shortcode($shortcode);
		echo '</div>';
	}

	private function build_shortcode_atts($atts) {
		$out = [];
		foreach ($atts as $key => $val) {
			if (!empty($val)) {
				if (is_array($val)) {
					$val = implode(',', $val); 
				}
				$out[] = $key . '="' . esc_attr($val) . '"';
			}
		}
		return implode(' ', $out);
	}

}