<?php

namespace AcademyBA\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class CurriculumTopbar extends \Bricks\Element {
	public $category = 'academy';
	public $name     = 'academyea-curriculum-topbar';
	public $icon     = 'ti-arrow-circle-up';

	public function get_label() {
		return esc_html__( 'Curriculum Topbar', 'academy-bricks-addons' );
	}

	/**
	 * Control Groups
	 */
	public function set_control_groups() {
		$this->control_groups['general_controls_group'] = [
			'title' => esc_html__( 'General', 'academy-bricks-addons' ),
			'tab'   => 'content',
		];

		$this->control_groups['progress_bar_group'] = [
			'title' => esc_html__( 'Progress Bar', 'academy-bricks-addons' ),
			'tab'   => 'content',
		];
		
		$this->control_groups['curriculum_section_style_group'] = [
			'title' => esc_html__( 'Curriculum Section Style', 'academy-bricks-addons' ),
			'tab'   => 'style',
		];		
		
		$this->control_groups['curriculum_logo_style_group'] = [
			'title' => esc_html__( 'Curriculum Logo Style', 'academy-bricks-addons' ),
			'tab'   => 'style',
		];

		$this->control_groups['curriculum_title_style_group'] = [
			'title' => esc_html__( 'Curriculum Title Style', 'academy-bricks-addons' ),
			'tab'   => 'style',
		];

		$this->control_groups['curriculum_progress_bar_style_group'] = [
			'title' => esc_html__( 'Curriculum Progress bar Style', 'academy-bricks-addons' ),
			'tab'   => 'style',
		];

		$this->control_groups['curriculum_share_button_style_group'] = [
			'title' => esc_html__( 'Curriculum Share Button Style', 'academy-bricks-addons' ),
			'tab'   => 'style',
		];

		
	}

	/**
	 * General
	 */
	public function set_controls() {

		/**
		 * content Tab
		 */
		//Logo
		$this->controls['curriculum_top_show_logo'] = [
			'group'	=> 'general_controls_group',
			'label' => esc_html__( 'Logo Show/Hidden', 'academy-elementor-addons' ),
			'type'  => 'select',
			'default' => 'block',
			'options' => [
				'block' => esc_html__( 'Show', 'academy-elementor-addons' ),
				'none'  => esc_html__( 'Hidden', 'academy-elementor-addons' ),
			],
			'css' => [
				[
					'property' => 'display',
					'selector' => '.academy-logo img, .academy-lesson-topbar__left .topbar-hr',
				],
			],
		];
		

   		// Curriculum Title Control
  		$this->controls['curriculum_top_title_content'] = [
			'group'	=> 'general_controls_group',		
            'label' => esc_html__( 'Title Show/Hidden', 'academy-elementor-addons' ),
            'type'  => 'select',
            'default' => 'block',
            'options' => [
                'block' => esc_html__( 'Show', 'academy-elementor-addons' ),
                'none'  => esc_html__( 'Hidden', 'academy-elementor-addons' ),
            ],
            'css' => [
                [
                    'property' => 'display',
                    'selector' => '.academy-lesson-topbar__left .academy-course-title a',
                ],
            ],
        ];

		// Curriculum Progress Bar Section (Bricks does not need start_controls_section)
		$this->controls['curriculum_top_progress_text'] = [
			'group'		=> 'progress_bar_group',
			'label' => esc_html__( 'Progressbar Text Show/Hidden', 'academy-elementor-addons' ),
			'type'  => 'select',
			'default' => 'flex',
			'options' => [
				'flex' => esc_html__( 'Show', 'academy-elementor-addons' ),
				'none' => esc_html__( 'Hidden', 'academy-elementor-addons' ),
			],
			'css' => [
				[
					'property' => 'display',
					'selector' => '.academy-course-progress__label',
				],
			],
		];

		$this->controls['curriculum_top_progress_title'] = [
			'group'		=> 'progress_bar_group',
			'label' => esc_html__( 'Progressbar Text', 'academy-elementor-addons' ),
			'type'  => 'text',
			'default' => esc_html__( 'Your Progress', 'academy-elementor-addons' ),
			'placeholder' => esc_html__( 'Type your title here', 'academy-elementor-addons' ),
		];

		$this->controls['curriculum_top_progress_main'] = [
			'group'		=> 'progress_bar_group',
			'label' => esc_html__( 'Progressbar Show/Hidden', 'academy-elementor-addons' ),
			'type'  => 'select',
			'default' => 'block',
			'options' => [
				'block' => esc_html__( 'Show', 'academy-elementor-addons' ),
				'none'  => esc_html__( 'Hidden', 'academy-elementor-addons' ),
			],
			'css' => [
					[
						'property' => 'display',
						'selector' => '.academy-progressbar',
					],
				],
		];

		// Share Text
		$this->controls['curriculum_top_share_text'] = [
			'group'       => 'general_controls_group',
			'label'       => esc_html__( 'Share Text', 'academy-elementor-addons' ),
			'type'        => 'text',
			'default'     => esc_html__( 'Share', 'academy-elementor-addons' ),
			'placeholder' => esc_html__( 'Type your title here', 'academy-elementor-addons' ),
		];


		/**
		 * style
		 */
		// Background Color
		$this->controls['curriculum_top_section_bg'] = [
			'group' => 'curriculum_section_style_group',
			'label' => esc_html__( 'Curriculum Background Color', 'academy-bricks-addons' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.academy-lesson-topbar',
				],
			],
		];
		
		// Close button Color
		$this->controls['curriculum_top_section_cancel_button'] = [
			'group' => 'curriculum_section_style_group',
			'label' => esc_html__( 'Curriculum Close Button Color', 'academy-bricks-addons' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => '.academy-lesson-topbar__right .academy-course-close .academy-icon',
				],
			],
		];

		// Close button BG Color
		$this->controls['curriculum_top_section_cancel_button_bg'] = [
			'group' => 'curriculum_section_style_group',
			'label' => esc_html__( 'Curriculum Close Button Background Color', 'academy-bricks-addons' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.academy-lesson-topbar__right .academy-course-close .academy-icon',
				],
			],
		];
		
		//Logo Width
		$this->controls['curriculum_top_logo_width'] = [
			'group'	 => 'curriculum_logo_style_group',
			'label'  => esc_html__( 'Logo Size', 'academy-bricks-addons' ),
			'type'   => 'number',
			'units'  => 'px',    
			'responsive' => true,
			'css' => [
				[
					'property' => 'width',
					'selector' => '.academy-logo img',
				],
			],
		];

		//Title Style
		$this->controls['curriculum_top_title_color'] = [
			'group' => 'curriculum_title_style_group',
			'label' => esc_html__( 'Title Typography', 'academy-bricks-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'typography',
					'selector' => '.academy-lesson-topbar__left .academy-course-title a',
				],
			],
			'exclude' => [
				'text-align',
			]
		];


		// Progress Bar Width & Height
		$this->controls['curriculum_top_progress_width_height'] = [
			'group'     => 'curriculum_progress_bar_style_group',
			'label'     => esc_html__( 'Progress Bar Width & Height', 'academy-bricks-addons' ),
			'type'      => 'number',
			'units'     => ['px', '%', 'em', 'rem'],
			'responsive'=> true,
			'css'       => [
				[
					'property' => 'width',
					'selector' => '.academy-progressbar svg',
				],
				[
					'property' => 'height',
					'selector' => '.academy-course-progress .academy-progressbar svg',
				],
			],
		];

		// Progress Bar Color
		$this->controls['curriculum_top_progress_main_color'] = [
			'group' => 'curriculum_progress_bar_style_group',
			'label' => esc_html__( 'Progress Bar Color', 'academy-bricks-addons' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'stroke',
					'selector' => '.academy-progressbar svg circle',
				],
			],
		];

		// ProgressBar Round Text Typography
		$this->controls['curriculum_top_progress_main_round_typography'] = [
			'group'    => 'curriculum_progress_bar_style_group',
			'label'    => esc_html__( 'ProgressBar Round Text Typography', 'academy-bricks-addons' ),
			'type'     => 'typography',
			'css'	   => [
				[
					'property' => 'typography',
					'selector' => '.academy-progressbar__text',
				]
			],
			'exclude' => [
				'text-align',
				'text-transform'
			]
		];

		// ProgressBar Label Typography
		$this->controls['curriculum_top_progress_label_typography'] = [
			'group'    => 'curriculum_progress_bar_style_group',
			'label'    => esc_html__( 'ProgressBar Label Typography', 'academy-bricks-addons' ),
			'type'     => 'typography',
			'css'	   => [
				[
					'property' => 'typography',
					'selector' => '.academy-course-progress__label p',
				]
			],
			'exclude' => [
				'text-align'
			]
		];

		// ProgressBar Label Icon Color
		$this->controls['curriculum_top_progress_label_icon_color'] = [
			'group' => 'curriculum_progress_bar_style_group',
			'label' => esc_html__( 'ProgressBar Label Icon Color', 'academy-bricks-addons' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => '.academy-course-progress__label .academy-icon',
				],
			],
		];

		// ProgressBar Label Icon Width
		$this->controls['curriculum_top_progress_label_icon_width'] = [
			'group'      => 'curriculum_progress_bar_style_group',
			'label'      => esc_html__( 'ProgressBar Label Icon Size', 'academy-bricks-addons' ),
			'type'       => 'number',
			'units'      => ['px', '%', 'em', 'rem'],
			'responsive' => true,
			'css'        => [
				[
					'property' => 'font-size',
					'selector' => '.academy-course-progress__label .academy-icon',
				],
			],
		];

		// Typography
		$this->controls['curriculum_top_share_button_typography'] = [
			'group'    => 'curriculum_share_button_style_group',
			'label'    => esc_html__( 'Share Button Typography', 'academy-bricks-addons' ),
			'type'     => 'typography',
			'css'	   => [
				[
					'property'	=> 'typography',
					'selector' => '.academy-btn--share',
				]
			]
		];

		// Normal Styles
		$this->controls['curriculum_top_share_button_normal_style'] = [
			'group'    => 'curriculum_share_button_style_group',
			'label'    => esc_html__( 'Normal Style', 'academy-bricks-addons' ),
			'type'     => 'color',
			'css'	   => [
				[
					'property' => 'color',					
					'selector' => '.academy-btn--share',
				]
			]
		];

		// Hover Styles
		$this->controls['curriculum_top_share_button_hover_style'] = [
			'group'    => 'curriculum_share_button_style_group',
			'label'    => esc_html__( 'Hover Style', 'academy-bricks-addons' ),
			'type'     => 'color',
			'css'	   =>[
				[
					'property' => 'color',
					'selector' => '.academy-btn--share:hover',
				]
			]
		];
	}

	/**
	 * Frontend Render
	 */
	public function render() {
		$settings = $this->settings ?? [];

		$attr_array = [
			'progress_ber_text' => $settings['curriculum_top_progress_title'],
			'share_text' => $settings['curriculum_top_share_text'],
		];

		$shortcode = '[academy_course_curriculum_topbar ' . $this->build_shortcode_atts( $attr_array ) . ']';

		// Wrapper div must exist for CSS to target
		echo '<div class="academy-search-form-wrap" ' . $this->render_attributes('_root') . '>';
		echo do_shortcode( $shortcode );
		echo '</div>';
	}

	/**
	 * Helper function → Build shortcode attributes
	 */
	private function build_shortcode_atts( $atts ) {
		$out = [];
		foreach ( $atts as $key => $val ) {
			if ( ! empty( $val ) ) {
				if ( is_array( $val ) ) {
					$val = implode( ',', $val );
				}
				$out[] = $key . '="' . esc_attr( $val ) . '"';
			}
		}
		return implode( ' ', $out );
	}
}