<?php

namespace AcademyBA\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Courses extends \Bricks\Element {
	public $category = 'academy';
	public $name     = 'academy-course-search';
	public $icon     = 'ti-search';

	public function get_label() {
		return esc_html__( 'Course Search', 'academy-bricks-addons' );
	}

	/**
	 * Control Groups
	 */
	public function set_control_groups() {
		$this->control_groups['general'] = [
			'title' => esc_html__( 'General', 'academy-bricks-addons' ),
			'tab'   => 'content',
		];

		$this->control_groups['search_bar_style_group'] = [
			'title' => esc_html__( 'Style', 'academy-bricks-addons' ),
			'tab'   => 'style',
		];
	}

	/**
	 * Controls
	 */
	public function set_controls() {
		// Placeholder Text
		$this->controls['search_text'] = [
			'group'       => 'general',
			'label'       => esc_html__( 'Placeholder Text', 'academy-bricks-addons' ),
			'type'        => 'text',
			'default'     => esc_html__( 'Search Course', 'academy-bricks-addons' ),
			'placeholder' => esc_html__( 'Type your title here', 'academy-bricks-addons' ),
		];

		// Height (Responsive)
		$this->controls['search_course_height'] = [
			'group'	 => 'search_bar_style_group',
			'label'  => esc_html__( 'Search Bar Height', 'academy-bricks-addons' ),
			'type'   => 'number',
			'units'  => 'px',    
			'responsive' => true,
			'css' => [
				[
					'property' => 'height',
					'selector' => '.academy-search-form__field-input',
				],
			],
		];

		// Background Color
		$this->controls['search_course_text_background'] = [
			'group' => 'search_bar_style_group',
			'label' => esc_html__( 'Background Color', 'academy-bricks-addons' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.academy-search-form__field-input',
				],
			],
		];

		// Border
		$this->controls['search_course_border'] = [
			'group' => 'search_bar_style_group',
			'label' => esc_html__( 'Border', 'academy-bricks-addons' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => '.academy-search-form__field-input',
				],
			],
		];

		// Typography
		$this->controls['search_course_typography'] = [
			'group' => 'search_bar_style_group',
			'label' => esc_html__( 'Typography', 'academy-bricks-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'typography',
					'selector' => '.academy-search-form__field-input',
				],
			],
		];

		$this->controls['form_placeholder__typography'] = [
			'group' => 'search_bar_style_group',
			'label' => esc_html__( 'Placeholder Typography', 'academy-bricks-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'typography',
					'selector' => '.academy-search-form__field-input::placeholder',
				],
			],
		];
	}

	/**
	 * Frontend Render
	 */
	public function render() {
		$settings = $this->settings ?? [];

		$attr_array = [
			'placeholder' => $settings['search_text'] ?? '',
		];

		$shortcode = '[academy_course_search ' . $this->build_shortcode_atts( $attr_array ) . ']';

		// Wrapper div must exist for CSS to target
		echo '<div class="academy-search-form-wrap" ' . $this->render_attributes('_root') . '>';
		echo do_shortcode( $shortcode );
		echo '</div>';
	}

	/**
	 * Helper function → Build shortcode attributes
	 */
	private function build_shortcode_atts( $atts ) {
		$out = [];
		foreach ( $atts as $key => $val ) {
			if ( ! empty( $val ) ) {
				if ( is_array( $val ) ) {
					$val = implode( ',', $val );
				}
				$out[] = $key . '="' . esc_attr( $val ) . '"';
			}
		}
		return implode( ' ', $out );
	}
}