<?php

namespace AcademyBA\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class CourseGrid extends \Bricks\Element {
	public $category = 'academy';
	public $name	 = 'academy-course-grid';
	public $icon	 = 'ti-view-grid';

	public function get_label(){
		return esc_html__( 'Academy Course Grid', 'academy-bricks-addons' );
	}

	/**
	 * controls
	 */

	public function set_control_groups(){
		
		//Course Layout Options
		$this->control_groups['course_layout_group'] = [
			'title'	=> esc_html__( 'Layout Options', 'academy-bricks-addons' ),
			'tab'	=> 'content',
		];

		$this->control_groups['course_query_options'] = [
			'title'	=>  esc_html__( 'Course Query', 'academy-bricks-addons' ),
			'tab'	=>	'content',
		];

		//Table Background
		$this->control_groups['table_bg_group'] = [
            'title' => esc_html__( 'Table Background', 'academy-bricks-addons' ),
			'tab'	=> 'style',
		];

		// Course Title
		$this->control_groups['course_title_group'] =[
			'title' => esc_html__( 'Course Title', 'academy-bricks-addons' ),
            'tab'   => 'style',
		];

		//Course price
		$this->control_groups['course_price_group'] = [
			'title' => esc_html__( 'Course Price', 'academy-bricks-addons' ),
			'tab'	=> 'style',
		];

		// Course Author
		$this->control_groups['course_author_group'] = [
			'title' => esc_html__( 'Course Author', 'academy-bricks-addons' ),
			'tab'   => 'style',
		];

		// Wishlist Icon Style
		$this->control_groups['wishlist_icon_style_group'] = [
			'title' => esc_html__( 'Wishlist Icon Style', 'academy-bricks-addons' ),
			'tab'   => 'style',
		];
	}

	public function set_controls(){

		/**
		 * Layout Options 
		 */
		$this->controls['course_columns'] = [
            'group' => 'course_layout_group',
            'label' => esc_html__('Course Columns', 'academy-bricks-addons'),
            'type'  => 'select',
            'options' => ['2'=>2,'3'=>3,'4'=>4,'6'=>6,'12'=>12],
            'default' => '3',
        ];

		$this->controls['allow_course_pagination'] = [
			'group'   => 'course_layout_group',
			'label'   => esc_html__('Show Pagination', 'academy-bricks-addons'),
			'type'    => 'select',
			'options' => [
				'yes' => esc_html__('Yes', 'academy-bricks-addons'),
				'no'  => esc_html__('No', 'academy-bricks-addons'),
			],
			'default' => 'no',
		];

		$this->controls['course_ids'] = [
			'group' => 'course_layout_group',
			'label'       => esc_html__("Course ID", 'academy-bricks-addons'),
			'description' => esc_html__("Enter Course ID's separated by comma", 'academy-bricks-addons'),
    		'type'        => 'textarea',
   			'placeholder' => '12, 15, 20',
		];

		/**
		 * Query Option
		 */
		$this->controls['course_count'] = [
			'group' => 'course_query_options',
            'label' => esc_html__('Course Per Page', 'academy-bricks-addons'),
            'type' => 'number',
            'default' => 6,
            'min' => 1,
            'max' => 1000
		];

		$this->controls['course_difficulty_level'] = [
			'group' => 'course_query_options',			
			'label'   => esc_html__( 'Difficulty Level', 'academy-bricks-addons' ),
			'type'    => 'select',
			'options' => [
				'beginner'     => __( 'Beginner', 'academy-bricks-addons' ),
				'intermediate' => __( 'Intermediate', 'academy-bricks-addons' ),
				'experts'      => __( 'Expert', 'academy-bricks-addons' ),
			],
			'multiple' => true,
		];

		$this->controls['course_price_type'] = [
            'group' => 'course_query_options',
            'label' => esc_html__('Price Type', 'academy-bricks-addons'),
            'type' => 'select',
            'multiple' => true,
            'options' => ['free'=>'Free','paid'=>'Paid']
        ];

		$this->controls['course_orderby'] = [
            'group' => 'course_query_options',
            'label' => esc_html__('Order By', 'academy-bricks-addons'),
            'type' => 'select',
            'options' => ['title'=>'Product Title','date'=>'Date','modified'=>'Modified Date'],
            'default' => 'date'
        ];

		$this->controls['course_order'] = [
            'group' => 'course_query_options',
            'label' => esc_html__('Order', 'academy-bricks-addons'),
            'type' => 'select',
            'options' => ['ASC'=>'Ascending','DESC'=>'Descending'],
            'default' => 'DESC'
        ];

		/**
		 * Table Background
		 */
		$this->controls['table_bg_color'] = [
			'group'	=> 'table_bg_group',
			'label'	=> esc_html__( 'Background Color', 'academy-bricks-addons' ),
			'type'	=> 'color',
			'css'	=> [
				[
					'property' => 'background-color',
					'selector' => '.academy-courses .academy-course',
				]
			]
		];

		$this->controls['table_bg_hover_color'] = [
			'group'		=> 'table_bg_group',
			'label'  	=> esc_html__( 'Hover Background Color', 'academy-bricks-addons' ),
            'type'   	=> 'color',
            'css'   	=> [	
				[
					'property' => 'background-color',
					'selector' => '.academy-courses .academy-course:hover',
				]
			],	
		];

		// Course Card Normal Border
		$this->controls['course_card_normal_border'] = [
			'group' => 'table_bg_group',
			'label' => esc_html__('Card Border', 'academy-bricks-addons'),
			'type'  => 'border',
			'css'   => [
				[
					'selector' => '.academy-row .academy-course',
				],
			],
		];


		/**
		 * Course Title
		 */
		$this->controls['course_title_color'] = [
			'group'   => 'course_title_group',
			'label'   => esc_html__( 'Color', 'academy-bricks-addons' ),
			'type'    => 'color',
			'css'     => [
				[
					'property' => 'color',
					'selector' => '.academy-row .academy-course .academy-course__title a',
				],
			],
		];

		$this->controls['course_title_hover_color'] = [
            'group'   => 'course_title_group',
            'label'   => esc_html__( 'Hover Color', 'academy-bricks-addons' ),
            'type'    => 'color',
            'css'     => [
				[
					'property' => 'color',
					'selector' => '.academy-row .academy-course .academy-course__title a:hover',
				],
			],			
		];
		
		$this->controls['course_title_typography'] = [
            'group'   => 'course_title_group',
            'label'   => esc_html__( 'Typography', 'academy-bricks-addons' ),
            'type'    => 'typography',
            'css'     => [
                [
					'property' => 'typography',
                    'selector' => '.academy-row .academy-course .academy-course__title a',
                ],
            ],
			'exclude' => [
				'color',
				'text-align'
			]
        ];

		/**
		 * Course Author
		 */
		$this->controls['course_author_color'] = [
            'group'   => 'course_author_group',
            'label'   => esc_html__( 'Color', 'academy-bricks-addons' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'color',
                    'selector' => '.academy-row .academy-course .academy-course__author .author, .academy-row .academy-course .academy-course__author .author a',
                ],
            ],
		];

		$this->controls['course_author_hover_color'] = [
			'group'   => 'course_author_group',
			'label'   => esc_html__( 'Hover Color', 'academy-bricks-addons' ),
			'type'    => 'color',
			'css'     => [
				'property' => 'color',
				'selector' => '.academy-row .academy-course:hover .academy-course__author .author, .academy-row .academy-course:hover .academy-course__author .author a',
			],
		];

		$this->controls['course_author_typography'] = [
			'group'		=>	'course_author_group',
			'label'  	=>	esc_html__( 'Typography', 'academy-bricks-addons' ),
			'type'   	=>	'typography',
			'css'		=>	[
				[
					'property' => 'typography',
					'selector' => '.academy-row .academy-course .academy-course__author .author, .academy-row .academy-course .academy-course__author .author a',
				]
			],
			'exclude' => [
				'color'
			]
		];

		/**
		 * Course Price
		 */
		$this->controls['course_price_color'] = [
			'group'	=>	'course_price_group',
			'label' => esc_html__( 'Color', 'academy-bricks-addons' ),
            'type'  => 'color',
            'css'   => [
                [
                    'property' => 'color',
                    'selector' => '.academy-row .academy-course .academy-course__price',
                ],
            ],
		];

		$this->controls['course_price_hover_color'] = [
            'group'   => 'course_price_group',
            'label'   => esc_html__( 'Hover Color', 'academy-bricks-addons' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'color',
                    'selector' => '.academy-row .academy-course:hover .academy-course__price',
                ],
            ],
        ];

        $this->controls['course_price_typography'] = [
            'group'   => 'course_price_group',
            'label'   => esc_html__( 'Typography', 'academy-bricks-addons' ),
            'type'    => 'typography',
            'css'     => [
                [
					'property' => 'typography',
                    'selector' => '.academy-row .academy-course .academy-course__price',
                ],
            ],
			'exclude' => [
				'color'
			]
        ];

		// Wishlist Icon Style
		$this->controls['wishlist_icon_color'] = [
			'group' => 'wishlist_icon_style_group',
			'label' => esc_html__('Wishlist Icon Color', 'academy-bricks-addons'),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => '.academy-courses .academy-course__header .academy-course-header-meta .academy-course__wishlist',
				],
			],
		];

		$this->controls['wishlist_icon_bg'] = [
			'group' => 'wishlist_icon_style_group',
			'label' => esc_html__('Wishlist Icon Background', 'academy-bricks-addons'),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.academy-courses .academy-course__header .academy-course-header-meta .academy-course__wishlist',
				],
			],
		];

		// Hover
		$this->controls['wishlist_icon_hover_color'] = [
			'group' => 'wishlist_icon_style_group',
			'label' => esc_html__('Wishlist Icon Hover Color', 'academy-bricks-addons'),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => '.academy-courses .academy-course__header .academy-course-header-meta .academy-course__wishlist:hover',
				],
			],
		];

		$this->controls['wishlist_icon_hover_bg'] = [
			'group' => 'wishlist_icon_style_group',
			'label' => esc_html__('Wishlist Icon Hover Background', 'academy-bricks-addons'),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.academy-courses .academy-course__header .academy-course-header-meta .academy-course__wishlist:hover',
				],
			],
		];

		// Position Controls
		$this->controls['wishlist_icon_left'] = [
			'group'      => 'wishlist_icon_style_group',
			'label'      => esc_html__('Wishlist Icon Left Position', 'academy-bricks-addons'),
			'type'       => 'number',
			'units'      => ['px', '%'],
			'responsive' => true,
			'css'        => [
				[
					'property' => 'left',
					'selector' => '.academy-courses .academy-course__header .academy-course-header-meta',
				],
			],
		];

		$this->controls['wishlist_icon_top'] = [
			'group'      => 'wishlist_icon_style_group',
			'label'      => esc_html__('Wishlist Icon Top Position', 'academy-bricks-addons'),
			'type'       => 'number',
			'units'      => ['px', '%'],
			'responsive' => true,
			'css'        => [
				[
					'property' => 'top',
					'selector' => '.academy-courses .academy-course__header .academy-course-header-meta',
				],
			],
		];
	}

	public function render() {
		$attr_array = [
			'count'            => $this->settings['course_count'] ?? -1,
			'columns'          => $this->settings['course_columns'] ?? 2,
			'ids'              => $this->settings['course_ids'] ?? '',
			// 'exclude_ids'    => $this->settings['course_exclude_ids'] ?? '',
			// 'category'       => $this->settings['course_categories'] ?? '',
			// 'cat_not_in'     => $this->settings['course_exclude_categories'] ?? '',
			'course_level'     => $this->settings['course_difficulty_level'] ?? [],
			'price_type'       => $this->settings['course_price_type'] ?? '',
			// 'tag'            => $this->settings['course_tags'] ?? '',
			// 'tag_not_in'     => $this->settings['course_exclude_tags'] ?? '',
			'orderby'          => $this->settings['course_orderby'] ?? 'date',
			'order'            => $this->settings['course_order'] ?? 'DESC',
			'column_per_row'   => $this->settings['course_columns'] ?? 2,
			'has_pagination'   => isset($this->settings['allow_course_pagination']) && $this->settings['allow_course_pagination'] === 'yes' ? true : false,
		];

		$shortcode = '[academy_courses ' . $this->build_shortcode_atts($attr_array) . ']';

		echo '<div ' . $this->render_attributes('_root') . '>';
		echo do_shortcode($shortcode);
		echo '</div>';
	}

	private function build_shortcode_atts($atts) {
		$out = [];
		foreach ($atts as $key => $val) {
			if (!empty($val)) {
				if (is_array($val)) {
					$val = implode(',', $val);
				}
				$out[] = $key . '="' . esc_attr($val) . '"';
			}
		}
		return implode(' ', $out);
	}

}