<?php
namespace AcademyBA\Widgets;

class CourseFilters extends \Bricks\Element {
    
    public $category = 'academy';
    public $name     = 'academyba-course-filters';
    public $icon     = 'ti-filter';

    public function get_label() {
        return esc_html__( 'Course Filters', 'academy-bricks-addons' );
    }

    /**
     * Control Group
     */
    public function set_control_groups() {
        $this->control_groups['search_options'] = [
            'title'     => esc_html__( 'Search Option' , 'academy-bricks-addons' ),
            'tab'       => 'style',
        ];

        $this->control_groups['typography_options'] = [
            'title'     => esc_html__( 'Typography Options' , 'academy-bricks-addons' ),
            'tab'       => 'style',
        ];

        $this->control_groups['checkbox_options'] = [
            'title'     => esc_html__( 'Check Option' , 'academy-bricks-addons' ),
            'tab'       => 'style',
        ];

        $this->control_groups['spacing_options'] = [
            'title'     => esc_html__( 'Spacing Options' , 'academy-bricks-addons' ),
            'tab'       => 'style',
        ];
    }

    /**
     * controls
     */
    public function set_controls(){
        $this->controls['course_filters_item_heading_typography'] = [
            'group'     => 'typography_options',
            'label'     => esc_html__('Label Typography' , 'academy-bricks-addons' ),
            'type'      => 'typography',
            'css'       => [
                [
                    'property' => 'typography',
                    'selector' => '.academy-course-filters .academy-archive-course-widget__title',
                ]
            ],
            'exclude' => [
                'text-align'
            ]
        ];

        $this->controls['course_filters_item_label_typography'] = [
            'group'     => 'typography_options',
            'label'     => esc_html__('Item Typography' , 'academy-bricks-addons' ),
            'type'      => 'typography',
            'css'       => [
                [
                    'property' => 'typography',
                    'selector' => '.academy-course-filters .academy-archive-course-widget__body label',
                ]
            ],
            'exclude' => [
                'text-align'
            ]
        ];

        $this->controls['course_filters_search_typography'] = [
            'group'     => 'search_options',
            'label'     => esc_html__( 'Typography' , 'academy-bricks-addons' ),
            'type'      => 'typography',
            'css'       => [
                [
                    'property' => 'typography',
                    'selector'  => '.academy-course-filters .academy-archive-course-widget--search input.academy-archive-course-search',
                ]
            ],
            'exclude' => [
                'text-align'
            ]

        ];

        $this->controls['course_filters_search_border'] = [
            'group'     => 'search_options',
            'label'     => esc_html__( 'Search Bar Border' , 'academy-bricks-addons' ),
            'type'      => 'border',
            'css'       => [
                [
                    'property' => 'border',
                    'selector'  => '.academy-course-filters .academy-archive-course-widget--search input.academy-archive-course-search',
                ]
            ] 

        ];

        $this->controls['course_filters_search_color'] = [
            'group'     => 'search_options',
            'label'     => esc_html__( 'Search Bar Color' , 'academy-bricks-addons' ),
            'type'      => 'color',
            'css'       => [
                [
                    'property' => 'background-color',
                    'selector' => '.academy-course-filters .academy-archive-course-widget--search input.academy-archive-course-search',
                ]
            ]

        ];
        
        $this->controls['course_filters_search_placeholder_color'] = [
            'group'     => 'search_options',
            'label'     => esc_html__( 'Input Placeholder Color' , 'academy-bricks-addons' ),
            'type'      => 'typography',
            'css'       => [
                [
                    'property' => 'typography',
                    'selector' => '.academy-course-filters .academy-archive-course-widget--search input.academy-archive-course-search::placeholder',
                ]
            ]
        ];
        
   		// Checkbox Styling Option
        $this->controls['course_filters_checkbox_size'] = [
            'group'   => 'checkbox_options',
            'label'   => esc_html__( 'Checkbox Size', 'academy-bricks-addons' ),
            'type'    => 'number',
            'unit' => 'px',
            'css'     => [
                [
                    'property' => 'width' ,
                    'selector' => '.academy-archive-course-widget__body label .checkmark',
                ],
                [
                    'property' => 'height' ,
                    'selector' => '.academy-archive-course-widget__body label .checkmark',
                ]
            ]
        ];

        $this->controls['course_filters_checkbox_border_size'] = [
            'group'     => 'checkbox_options',
            'label'     => esc_html__( 'Checkbox Border Size', 'academy-bricks-addons' ),
            'type'      => 'number',
            'unit'     => 'px',
            'css'       => [
                [
                    'property'  => 'border-width',
                    'selector'  => '.academy-archive-course-widget__body label .checkmark',
                ]
            ]
        ];

        $this->controls['course_filters_checkbox_border_color'] = [
            'group'     => 'checkbox_options',
            'label'     => esc_html__( 'Border Color', 'academy-bricks-addons' ),
            'type'      => 'color',
            'css'       => [
                [
                    'property'  => 'border-color',
                    'selector'  => '.academy-archive-course-widget__body label .checkmark',
                ]
            ]
        ];

        $this->controls['course_filters_checkbox_checked_background'] = [ 
            'group'     => 'checkbox_options',
            'label'     => esc_html__( 'Checked Background Color', 'academy-bricks-addons' ),
            'type'      => 'color',
            'css'       => [
                [
                    'property'  => 'background-color',
                    'selector'  => '.academy-course-filters .academy-archive-course-widget__body label input:checked ~ .checkmark',
                ]
            ]
        ];

        $this->controls['course_filters_checkbox_checked_color'] = [ 
            'group'     => 'checkbox_options',
            'label'     => esc_html__( 'Checked Color', 'academy-bricks-addons' ),
            'type'      => 'color',
            'css'       => [
                [
                    'property'  => 'border-color',
                    'selector'  => '.academy-course-filters .academy-archive-course-widget__body label .checkmark:after',
                ]
            ]
        ];

        // Spacing Styling Option
        $this->controls['course_filters_widgets_heading_spacing'] = [
            'group'     => 'spacing_options',
            'label'   => esc_html__( 'Filter Widgets Heading', 'academy-bricks-addons' ),
            'type'    => 'number',
            'unit'     => 'px',
            'css'     => [
                [
                    'property'  => 'margin-bottom',
                    'selector'  => '.academy-course-filters .academy-archive-course-widget__title',
                ]
            ]
        ];
        
        $this->controls['course_filters_widgets_spacing'] = [
            'group'     => 'spacing_options',
            'label'   => esc_html__( 'Space Between Filter Widgets', 'academy-bricks-addons' ),
            'type'    => 'number',
            'unit'     => 'px', 
            'css'     => [
                [
                    'property'  => 'margin-bottom',
                    'selector'  => '.academy-course-filters .academy-archive-course-widget',
                ]
            ]
        ];
        
        $this->controls['course_filters_widget_item_spacing'] = [
            'group'     => 'spacing_options',
            'label'   => esc_html__( 'Space Between Widget item', 'academy-bricks-addons' ),
            'type'    => 'number',
            'unit'     => 'px', 
            'css'     => [
                [
                    'property'  => 'margin-bottom',
                    'selector'  => '.academy-course-filters .academy-archive-course-widget__body label',
                ]
            ]
        ];
        
        $this->controls['course_filters_widget_checkbox_and_text_item_spacing'] = [
            'group'     => 'spacing_options',
            'label'   => esc_html__( 'Space Between Checkbox & Text', 'academy-bricks-addons' ),
            'type'    => 'number',
            'unit'     => 'px',  
            'css'     => [
                [
                    'property'  => 'padding-left',
                    'selector'  => '.academy-course-filters .academy-archive-course-widget__body label',
                ]
            ]
        ];
    }

    /**
     * Frontend Render
     */
    public function render() {
        $settings = $this->settings;        
        $shortcode = '[academy_course_filters]';
        echo '<div class="academy-search-form-wrap" ' . $this->render_attributes('_root') . '>';
        echo do_shortcode( $shortcode);
        echo '</div>';
    }
}