<?php
namespace AcademyBA\Widgets;

class CourseEnrollForm extends \Bricks\Element {
    
    public $category = 'academy';
    public $name     = 'academyba-course-enroll-form';
    public $icon     = 'ti-notepad';

    public function get_label() {
        return esc_html__( 'Course Enroll Form' ,'academy-bricks-addons' );
    }

    /**
     * Controls
     */
    public function set_control_groups() {
        $this->control_groups['general_settings_group'] = [
            'title'     => esc_html__('General Settings' , 'academy-bricks-addons'),
            'tab'       => 'content',
        ];

        $this->control_groups['enroll_button_group'] = [
            'title'     => esc_html__('Enroll Button' , 'academy-bricks-addons'),
            'tab'       => 'style',
        ];
        $this->control_groups['start_course_button_group'] = [
            'title'     => esc_html__('Start Course Button' , 'academy-bricks-addons'),
            'tab'       => 'style',
        ];
        $this->control_groups['complete_course_button_group'] = [
            'title'     => esc_html__('Complete Course Button' , 'academy-bricks-addons'),
            'tab'       => 'style',
        ];
        $this->control_groups['cart_button_group'] = [
            'title'     => esc_html__('Cart Button' , 'academy-bricks-addons'),
            'tab'       => 'style',
        ];
    }

    public function set_controls(){
        // content
        $this->controls['course_id'] = [
            'group'     => 'general_settings_group',
            'label'     =>  esc_html__('Course id' , 'academy-bricks-addons'),
            'type'      => 'number',
            'min'       => 1,
        ];

        // Enroll Button
        $this->controls['enroll_button_h'] = [
            'group'   => 'enroll_button_group',
            'label'   => esc_html__('Typography', 'academy-bricks-addons'),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '.academy-widget-enroll__enroll-form button.academy-btn',
                ]
            ],
            'exclude' => [
				'text-align'
			]
        ];

        $this->controls['enroll_button_bg'] = [
            'group'   => 'enroll_button_group',
            'label'   => esc_html__('Background', 'academy-bricks-addons'),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'background-color',
                    'selector' => '.academy-widget-enroll__enroll-form button.academy-btn',
                ],
            ],
        ];

        $this->controls['enroll_button_bg_h'] = [
            'group'   => 'enroll_button_group',
            'label'   => esc_html__('Hover Style', 'academy-bricks-addons'),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'background-color',
                    'selector' => '.academy-widget-enroll__enroll-form:hover .academy-btn',
                ],
            ],
        ];

        // Start Course Button
        $this->controls['start_course_button'] = [
            'group'   => 'start_course_button_group',
            'label'   => esc_html__('Typography', 'academy-bricks-addons'),
            'type'    => 'typography',
            'css'     => [
                [   'property' => 'typography',
                    'selector' => '.academy-widget-enroll__continue a',
                ]
            ],
            	'exclude' => [
				'text-align'
			]
        ];

        $this->controls['start_course_button_bg'] = [
            'group'   => 'start_course_button_group',
            'label'   => esc_html__('Background', 'academy-bricks-addons'),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'background-color',
                    'selector' => '.academy-widget-enroll__continue .academy-btn',
                ],
            ],
        ];

        $this->controls['start_course_button_bg_h'] = [
            'group'   => 'start_course_button_group',
            'label'   => esc_html__('Hover Style', 'academy-bricks-addons'),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'background-color',
                    'selector' => '.academy-widget-enroll__continue:hover .academy-btn',
                ],
            ],
        ];

        // Complete Course Button
        $this->controls['complete_course_button'] = [
            'group'   => 'complete_course_button_group',
            'label'   => esc_html__('Typography', 'academy-bricks-addons'),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '.academy-widget-enroll__complete-form button.academy-btn'
                ]
            ],
            'exclude' => [
				'text-align'
			]
        ];

        $this->controls['complete_course_button_bg'] = [
            'group'   => 'complete_course_button_group',
            'label'   => esc_html__('Background', 'academy-bricks-addons'),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'background-color',
                    'selector' => '.academy-widget-enroll__complete-form button.academy-btn',
                ],
            ],
        ];
        
        $this->controls['complete_course_button_hover'] = [
            'group'   => 'complete_course_button_group',
            'label'   => esc_html__('Hover Style', 'academy-bricks-addons'),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'background-color',
                    'selector' => '.academy-widget-enroll__complete-form button.academy-btn:hover',
                ],
            ],
        ];

        // Cart Button
        $this->controls['cart_button'] = [
            'group'   => 'cart_button_group',
            'label'   => esc_html__('Typography', 'academy-bricks-addons'),
            'type'    => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '.academy-widget-enroll__add-to-cart a',
                ]
            ],
            'exclude' => [
				'text-align'
			]
        ];

        $this->controls['cart_button_bg'] = [
            'group'   => 'cart_button_group',
            'label'   => esc_html__('Background', 'academy-bricks-addons'),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'background-color',
                    'selector' => '.academy-widget-enroll__add-to-cart a',
                ],
            ],
        ];

        $this->controls['cart_button_hover'] = [
            'group'   => 'cart_button_group',
            'label'   => esc_html__('Hover Style', 'academy-bricks-addons'),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'background-color',
                    'selector' => '.academy-widget-enroll__add-to-cart:hover a',
                ],
            ],
        ];
    }

    /**
     * Frontend Render
     */
    public function render() {
        $settings = $this->settings;
		$shortcode = '[academy_enroll_form course_id="' . esc_attr( $settings['course_id'] ?? '' ) . '"]';
        echo '<div ' . $this->render_attributes( '_root' ) . '>';
        echo do_shortcode( $shortcode );
        echo '</div>';
    }
}