<?php
/**
 * Plugin Name: Academy Bricks Addons
 * Description: Bricks Integration - Design your eLearning website using Academy Bricks Addons.
 * Plugin URI:  https://demo.academylms.net
 * Version:     1.0.0
 * Author:      Kodezen
 * Author URI:  https://academylms.net
 * Text Domain: academy-bricks-addons
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}


/**
 * Main Plugin Class
 */
final class Academy_Bricks_Addons {

    /**
     * Plugin version
     */
    const VERSION = '1.0.0';

    /**
     * Instance
     *
     * @var self|null
     */
    private static $instance = null;

    /**
     * Constructor
     */
    private function __construct() {
        $this->define_constants();
        $this->load_dependency();
        // Hooks
        register_activation_hook( __FILE__, [ $this, 'activate' ] );
        register_deactivation_hook( __FILE__, [ $this, 'deactivate' ] );
        add_action( 'plugins_loaded', [ $this, 'init_plugin' ] );
        add_action( 'init', [ $this, 'init_widgets' ], 11 );
        add_filter('academy/is_load_common_scripts', '__return_true');
    }

    /**
     * Define plugin constants
     */
    private function define_constants() {
        define( 'ACADEMY_BA_VERSION', '1.0.0' );
		define( 'ACADEMY_BA_ADDONS_SETTINGS_NAME', 'academy_addons' );
		define( 'ACADEMY_BA_PLUGIN_FILE', __FILE__ );
		define( 'ACADEMY_BA_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		define( 'ACADEMY_BA_PLUGIN_SLUG', 'academy' );
		define( 'ACADEMY_BA_PLUGIN_ROOT_URI', plugins_url( '/', __FILE__ ) );
		define( 'ACADEMY_BA_ROOT_DIR_PATH', plugin_dir_path( __FILE__ ) );
		define( 'ACADEMY_BA_INCLUDES_DIR_PATH', ACADEMY_BA_ROOT_DIR_PATH . 'includes/' );
		define( 'ACADEMY_BA_ASSETS_DIR_PATH', ACADEMY_BA_ROOT_DIR_PATH . 'assets/' );
		define( 'ACADEMY_BA_TEMPLATE_DEBUG_MODE', false );
    }

    /**
     * Plugin activation
     */
    public function activate() {

        if ( ! class_exists( '\Bricks\Element' ) || ! class_exists( '\Bricks\Elements' ) ) {
            deactivate_plugins( plugin_basename( __FILE__ ) );

            wp_die(
                '<h2 style="color:#d63638;">Bricks Builder Missing!</h2>
                <p>Academy Bricks Addons plugin requires <strong>Bricks Builder</strong> to be installed and activated.</p>',
                'Plugin dependency missing',
                [ 'back_link' => true ]
            );
        }

        if ( ! get_option( 'aba_installed' ) ) {
            update_option( 'aba_installed', time() );
        }

        update_option( 'aba_version', self::VERSION );
    }



    /**
     * Plugin deactivation
     */
    public function deactivate() {
        // Optional: cleanup tasks
    }

    /**
     * Initialize plugin
     */
    public function init_plugin() {
        add_filter( 'bricks/elements/categories', function( $categories ) {
			$categories['academy-bricks'] = esc_html__( 'Academy Bricks', 'academy-bricks-addons' );
			return $categories;
		} );
		
    }
    public function init_widgets() {

        $element_files = [
            ACADEMY_BA_INCLUDES_DIR_PATH . 'widgets/course-filters.php',
            ACADEMY_BA_INCLUDES_DIR_PATH . 'widgets/course-enroll-from.php',
            ACADEMY_BA_INCLUDES_DIR_PATH . 'widgets/course-search.php',
            ACADEMY_BA_INCLUDES_DIR_PATH . 'widgets/registration.php',
            ACADEMY_BA_INCLUDES_DIR_PATH . 'widgets/login-form.php',
            ACADEMY_BA_INCLUDES_DIR_PATH . 'widgets/course-grid.php',
            ACADEMY_BA_INCLUDES_DIR_PATH . 'widgets/curriculum-topbar.php',
        ];

        foreach ( $element_files as $file ) {
            \Bricks\Elements::register_element( $file );
        }
    }

    public function load_dependency() {
		require_once ACADEMY_BA_INCLUDES_DIR_PATH . 'autoload.php';
	}

    /**
     * Get instance (singleton)
     *
     * @return self
     */
    public static function init() {
        if ( self::$instance === null ) {
            self::$instance = new self();
        }

        return self::$instance;
    }
}

/**
 * Initialize the plugin
 *
 * @return Academy_Bricks_Addons
 */
function academy_bricks_addons() {
    return Academy_Bricks_Addons::init();
}

// Kick-off
academy_bricks_addons();